/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.actions;

import com.aptana.git.core.model.ChangedFile;
import com.aptana.git.core.model.GitRepository;
import com.aptana.git.ui.internal.actions.AbstractStagingHandler;
import com.aptana.git.ui.internal.actions.Messages;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevertHandler
extends AbstractStagingHandler {
    @Override
    protected void doOperation(GitRepository repo, List<ChangedFile> changedFiles) {
        final HashSet<IResource> changedResources = new HashSet<IResource>();
        block0: for (IResource resource : this.getSelectedResources()) {
            File file = new File(resource.getLocationURI());
            for (ChangedFile changedFile : changedFiles) {
                if (!file.getAbsolutePath().endsWith(changedFile.getRelativePath().toOSString())) continue;
                changedResources.add(resource);
                continue block0;
            }
        }
        repo.index().discardChangesForFiles(changedFiles);
        WorkspaceJob job = new WorkspaceJob(Messages.RevertAction_RefreshJob_Title){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                int work = 100 * changedResources.size();
                SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)work);
                for (IResource resource : changedResources) {
                    if (sub.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    resource.refreshLocal(2, (IProgressMonitor)sub.newChild(100));
                }
                sub.done();
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setUser(true);
        job.schedule();
    }

    @Override
    protected boolean changedFileIsValid(ChangedFile correspondingChangedFile) {
        return correspondingChangedFile != null && correspondingChangedFile.hasUnstagedChanges() && correspondingChangedFile.getStatus() == ChangedFile.Status.MODIFIED;
    }
}

